document.addEventListener('DOMContentLoaded', () => {
    // Navbar Scroll Effect
    const navbar = document.querySelector('.navbar');
    const startsTransparent = navbar && !navbar.classList.contains('scrolled');

    window.addEventListener('scroll', () => {
        if (window.scrollY > 50) {
            navbar.classList.add('scrolled');
        } else if (startsTransparent) {
            navbar.classList.remove('scrolled');
        }
    });

    // Basic Hero Slider Logic (Automatic)
    const slides = document.querySelectorAll('.hero-slider-item');
    if (slides.length > 1) {
        let currentSlide = 0;
        setInterval(() => {
            slides[currentSlide].classList.remove('active');
            currentSlide = (currentSlide + 1) % slides.length;
            slides[currentSlide].classList.add('active');

            // Re-trigger entrance animation for text using GSAP if available
            if (typeof gsap !== 'undefined') {
                gsap.from(slides[currentSlide].querySelector('.hero-content'), {
                    y: 30,
                    opacity: 0,
                    duration: 1,
                    ease: 'power2.out'
                });
            }
        }, 6000);
    }

    // --- Page Transition (Fade In) ---
    document.body.style.opacity = '0';
    document.body.style.transition = 'opacity 0.8s ease-in-out';

    // Tiny timeout to ensure DOM is ready and CSS transition takes effect
    setTimeout(() => {
        document.body.style.opacity = '1';
    }, 100);
});
